STRAT=rep(c(1:11),11)

brFun = function(BB,ab) {
    if(ab=="A") x = as.data.frame(list(br=STRAT[BB$best[,,ab]],other=STRAT[t(BB$best[,,ab])]))
    else x = as.data.frame(list(br=STRAT[t(BB$best[,,ab])],other=STRAT[BB$best[,,ab]]))
    x = aggregate(x,list(x$other),mean)[,c("other","br")]
    x = cbind(x,BB$par$Pi,which(ab==c("A","B")))
    colnames(x)=c("guessedOtherChoice","bestReply","usedpi","type")
    x
  }

brPlot = function(BB,xlab="own choice of player A",ylab="own choice of player B",show=c(TRUE,TRUE),expResponse=NULL,col="black",new=TRUE,...) {
  legs <- c("A","B")
  if (abs(BB$par$Pi-.5)>.05) legs <- c("A (strong)","B (weak)")
  BR=function(ab,...) {
    dots=list(x=STRAT[BB$best[,,ab]],y=STRAT[t(BB$best[,,ab])])
    points(dots,...)
    lines(dots,...)
    if (!is.null(expResponse)) {
      if (ab=="A") dots=subset(expResponse,usedpi == BB$par$Pi & type == 1)[,c("x","guessedOtherChoice")]
      if (ab=="B") dots=subset(expResponse,usedpi == BB$par$Pi & type == 2)[,c("guessedOtherChoice","x")]
      points(dots,lwd=2,col="red",...)
      lines(dots,lwd=2,col="red",...)
    }
  }
  if (new) plot(NULL,xlim=c(1,11),ylim=c(1,11),xlab=xlab,ylab=ylab,...)
  if (show[1]) BR("A",pch=2,col=col)
  if (show[2]) BR("B",lty=2,pch=3,col=col)
  if (new) legend(1,11,legend=legs,lty=c(1,2),pch=c(2,3))
  mtext(paste("$\\pi=",BB$par$Pi,",\\theta=",BB$par$S,"\\alpha=",BB$par$alpha,"$"))
}

iInvest = function (data,wish=FALSE,myflex=FALSE) {
  if (wish) {
    est1 = coef(lmList(over ~ fair  | subjectid ,data=subset(data,fairWish==FALSE)))
    est1$fairWish=FALSE
    est2 = coef(lmList(over ~ fair  | subjectid ,data=subset(data,fairWish==TRUE)))
    est2$fairWish=TRUE
    est1 = rbind(est1,est2)
    }
  else {
    dd = data[,c("over","fair","flex","subjectid")]
    if (!is.null(myflex)) dd <- subset(dd,flex=myflex)
    est1 = coef(lmList(over ~ fair *  flex | subjectid,data=dd))
  }
  est1$subjectid=rownames(est1)
  estCoef = merge(est1,aggregate(icF[,c("indepobs","type","expensive","startFair")],list(subjectid=icF$subjectid),function(x) x[1]))
  colnames(estCoef)[which(colnames(estCoef)=="(Intercept)")]="Intercept"
  estCoef = transform (estCoef, fairTot = Intercept + fairTRUE)
  estCoef = transform (estCoef, exp = ifelse(expensive,"exp.","inexp."))
  estCoef = transform (estCoef, tname = ifelse(type==1,"strong","weak."))
  estCoef
}

fsfind = function (fsa=0,fsb=0,pay) {
  qq=payA(Pi=pay$par$Pi,S=pay$par$S,alpha=pay$par$alpha,beta=pay$par$beta,fsa=fsa,fsb=fsb)
  eqSum=apply(qq$eq$strat,2,sum)
  unlist(c(list(fsa=fsa),list(fsb=fsb),qq$eq$strat[,which(max(eqSum)==eqSum)[1]]))
}


fsGraph = function  (pay,dir=c(1,1),by=.1,end=2,lty=1,add=FALSE,pos=1,col="black",xlab="own choice of player A",ylab="own choice of player B") {
  aa=cbind(seq(0,end,by=by)) %*% dir
  qq = as.data.frame(t(apply(aa,1,function(x) fsfind(fsa=x[1],fsb=x[2],pay))))
  qq3=aggregate(qq,list(qq$A,qq$B),min)
  qq3=qq3[order(qq3$fsa,qq3$fsb),c("fsa","fsb","A","B")]
  if (!add) brPlot(pay,xlab=xlab,ylab=ylab)
  with(qq3,lines(1+B,1+A,lwd=3,lty=lty,col=col))
  if (dir[1]>0) {
    with(qq3,text(1+B,1+A,round(fsa,1),pos=pos,col=col))
  } else {
    with(qq3,text(1+B,1+A,round(fsb,1),pos=pos,col=col))
  }
}

payA = function (Pi=Piunfair,cost=50,S=14,alpha=.41,beta=.41,MA=500,MB=500,fsa=0,fsb=0) {
  ia=(0:10)
  ib=(0:10)
  gain=50^alpha*50^beta*S
  PA0=outer(ia,ib,function(IA,IB) {round(MA-IA*cost+Pi*gain*IA^alpha*IB^beta,0)})
  PB0=outer(ia,ib,function(IA,IB) {round(MB-IB*cost+(1-Pi)*gain*IA^alpha*IB^beta,0)})
  PA = PA0 - fsa * pmax( PB0 - PA0,0)  - fsb * pmax( PA0 - PB0,0) 
  PB = PB0 - fsa * pmax( PA0 - PB0,0)  - fsb * pmax( PB0 - PA0,0) 
  bestA=apply(PA,2,function(x) {x==max(x)})
  bestB=t(apply(PB,1,function(x) {x==max(x)}))
  qq=(bestA & bestB)
  eqA=ia[apply(qq,2,max)==1]
  eqB=ib[apply(qq,1,max)==1]
  eqStrat=rbind(eqA,eqB)
  eqPayA=PA[bestA & bestB]
  eqPayB=PB[bestA & bestB]
  eqPay=rbind(eqPayA,eqPayB)
  rownames(eqPay)=c("A","B")
  rownames(eqStrat)=c("A","B")
  pay=array(c(PA,PB),c(dim(PA),2))
  best=array(c(bestA,bestB),c(dim(bestA),2))
  dimnames(pay)=list(ia,ib,c("A","B"))
  dimnames(best)=list(ia,ib,c("A","B"))
  list(par=list(i=list(A=ia,B=ib),Pi=Pi,cost=cost,S=S,alpha=alpha,beta=beta,MA=MA,MB=MB),pay=pay,
       best=best,eq=list(pay=eqPay,strat=eqStrat))
}

NashPay = function (pay) {
  xx=cbind(pay$pay[,,"A"][pay$best[,,"A"] & pay$best[,,"B"]],
       y=pay$pay[,,"B"][pay$best[,,"A"] & pay$best[,,"B"]])
  colnames(xx)=c("own","other")
  xx
}

symText <- function(sym,exp=0,prefix="") {
  SYM=ifelse(sym==1,"SYM",ifelse(sym==2,"ASYM",ifelse(sym==3,"FLEX","")))
  EXP=ifelse(exp==expensive,"-C",ifelse(exp==inexpensive,"-NC",""))
  sprintf("%s%s%s",prefix,SYM,EXP)
}
chPlot = function(payUF,payF,show=c(TRUE,TRUE),add=FALSE,diaglty="dotted") {
  aMax=max(payUF$pay[,,"A"],payF$pay[,,"A"],payUF$pay[,,"B"],payF$pay[,,"B"])
  payUF.vec = cbind(as.vector(payUF$pay[,,"A"]),as.vector(payUF$pay[,,"B"]))
  payF.vec = cbind(as.vector(payF$pay[,,"A"]),as.vector(payF$pay[,,"B"]))
  if(!add) plot(NULL,xlim=c(0,aMax),ylim=c(0,aMax),xlab="Payoff player A",ylab="Payoff player B")
  iUF=chull(payUF.vec)
  iUF=c(iUF,iUF[1])
  iF=chull(payF.vec)
  iF=c(iF,iF[1])
  if (show[1]) {
    lines(payUF.vec[iUF,],lty="dashed")
    points(NashPay(payUF),pch=3)
    text(NashPay(payUF),symText(2,0,"Nash "),pos=1)
  }
  if (show[2]) {
    lines(payF.vec[iF,])
    points(NashPay(payF))
    text(NashPay(payF),symText(1,0,"Nash "),pos=3)
  }
  abline(a=0,b=1,lty=diaglty)
  mtext(paste("\\raisebox{1ex}{$\\pi_{\\rm SYM}=",payF$par$Pi,",\\pi_{\\rm ASYM}=",payUF$par$Pi,",\\theta=",payF$par$S,",\\alpha=",payF$par$alpha,"$}"),cex=.95)
}
twopay = function(vec) {
  sprintf("\\TP{%g}{%g}",vec[1],vec[2])
}
twopay2 = function(arr) {
  cat(sprintf("\\TP%s{%g}{%g}",array(c("o","A","B","E"),c(2,2))[arr[1,"BR"]+1,arr[2,"BR"]+1],arr["A","pay"],arr["B","pay"]))
}
laTab = function (zz,rest,table=TRUE,hix=NULL,hiy=NULL,playerBname="player B",playerAname="player A") {
   zz$best[ , ,     ]<-FALSE
   if (hix<=dim(zz$best)[2]) zz$best[ ,hix,"A"]<-TRUE
   if (hiy<=dim(zz$best)[1]) zz$best[hiy, ,"B"]<-TRUE
   pay2=array(c(zz$pay,zz$best),c(dim(zz$pay),2))
   Lfac<-if (is.null(hix)) 50 else 1
   Ladd<-if (is.null(hix)) 0 else 1
   ia=dimnames(zz$pay)[[1]]
   ib=dimnames(zz$pay)[[2]]
   ibn<-sprintf("%s %d",ifelse(hix==as.numeric(ib)+1,"\\red",""),as.numeric(ib)*Lfac+Ladd)
   dimnames(pay2)=list(ia,ib,dimnames(zz$pay)[[3]],c("pay","BR"))
   if (table) cat("\\begin{table}\\begin{center}")
   cat("\\setlength\\arraycolsep{0.1em}\\scriptsize\\begin{tabular}{c@{}l}&")
   if(is.null(hix)) cat(sprintf("$\\pi=%g, \\vartheta=%g,  \\alpha=%g$\\hfill ",zz$par$Pi,zz$par$S,zz$par$alpha))
   cat(playerBname,"\\hfill\\mbox{} \\\\\\rotatebox{90}{\\makebox[0pt][c]{",playerAname,"}}&\\begin{tabular}{c|",rep("@{\\,}c@{\\,}|",length(ib)),"}\n",sep="")
   cat(c("",ibn),sep="&")
   cat("\\\\\\hline\n")
   for (IA in ia) {
     if (as.numeric(IA)+Ladd==hiy) cat("\\red ")
     cat(Lfac*as.numeric(IA)+Ladd)
     apply(pay2[IA,,,],1,twopay2)
     cat("\\\\\\hline\n")
  }
  cat("\\end{tabular}\\end{tabular}",rest,"\n")
   if (table) cat("\\end{center}\\end{table}\n")
}


gsmerge = function (fname) {
  if (length(fname)==1) {
    ic = splittable(fname)
    globals = ic$globals[ic$globals$Treatment==2,]
    subjects = ic$subjects[ic$subject$Treatment==2,]
    return(merge(subjects,globals))
  }
  all = gsmerge(fname[1])
  for (name in fname[-1]) {
    print(name)
    all=merge(all,gsmerge(name),all=TRUE)
  }
}

clm = function (formula, data, id ,depvar="$\\beta$",rownames=NULL ) {
  data=data[order(data[,id]),]
  data$myid <- data[,id]
  options(scipen=5)
  x=summary(geeglm ( formula, data=data, id=myid ))
  y=coefficients(x)
  if (!is.null(rownames)) rownames(y)=rownames
  y=round(y,digits=4)
  colnames(y)=c(depvar,"$\\sigma$","Wald","$p(>W)$")
  latex(y,file="",rowlabel="",table.env=FALSE,center="none")
  cat(sprintf("\\centerline{%d independent observations, max. size of clusters=%d}",length(x$geese$clusz),max(x$geese$clusz)))
}

mer2ctab <- function (mer,relimp=FALSE,type="pmvd",boot=NULL) {
  ctab <- summary(mer)@coefs
  if (!is.null(boot)) {
    ctab[,"Std. Error"] <- apply(boot@fixef,1,sd)
    ctab[,"t value"] <-  ctab[,"Estimate"] / ctab[,"Std. Error"]
  }
  if (length(colnames(ctab))==4) {
    ctab <- cbind(ctab, ctab[,"Estimate"] +   cbind(ctab[,"Std. Error"]*abs(qnorm(.025))) %*% c(-1,1))
  } else {
    df <- mer@dims["n"]-mer@dims["q"]-mer@dims["p"]+1
    ctab <- cbind(ctab,2*pt(-abs(ctab[,"t value"]),df=df))
    ctab <- cbind(ctab, ctab[,"Estimate"] +   cbind(ctab[,"Std. Error"]*abs(qt(.025,df=df))) %*% c(-1,1))
  }
  colnames(ctab)[4:6]=c("p value","confsub","confsup")
  ctab<-as.data.frame(ctab)
  if (relimp) {
    rownames(ctab)<-sub("TRUE","",rownames(ctab))
    lmformula <- paste(sapply(c(2,3),function(i) attr(mer@frame,"terms")[[i]]),collapse="~")
    mer.lm <- lm(lmformula,data=mer@frame)
    relimp <- eval(parse(text=sprintf("calc.relimp(mer.lm,type='%s',rela=TRUE)@%s",type,type)))
    ctab[[type]]<-NA
    for(name in names(relimp)) ctab[name,type]<-relimp[name]
  }
  ctab
}

mer2la <- function (mer=NULL,ctab=NULL,trans=NULL,relimp=FALSE,type="pmvd",strip=NULL,boot=NULL) {
  if (is.null(ctab)) ctab <- mer2ctab(mer,relimp=relimp,type=type,boot=boot)
  relimp=dim(ctab)[2]==7
  if(relimp) type=colnames(ctab)[7]
  cc <- ctab
  if (!is.null(strip)) {
    delVec <- grep(strip,rownames(ctab))
    delVec2 <- delVec[ctab[delVec,type]<.05]
    if (length(delVec2)>0) {
      ctab <- ctab[-delVec2,]
      if(relimp) ctab["other",type]<-1-sum(ctab[,type],na.rm=TRUE)
    }
  }
  colnames(ctab)[1:2]=c("$\\beta$","$\\sigma$")
  colnames(ctab)[4:6]=c("$p$ value","95\\% conf","interval")
  colnames(ctab)[colnames(ctab)=="t value"]<-"$t$"
  colnames(ctab)[colnames(ctab)=="z value"]<-"$z$"
  if (length(dim(trans))==2) {
    rn <- rownames(ctab)
    rn <- sub("TRUE$","",rn)
    apply(trans,1,function(x) {rn<<-sub(paste("^",x[1],"$",sep=""),x[2],rn);})
    rownames(ctab)<-rn
  }
  if (relimp)
    print(xtable(ctab,digits=c(1,3,3,3,4,3,3,3),display=c("fg","fg","fg","fg","f","fg","fg","f"),align="l||c|c|c|c|cc|c"),floating=FALSE,sanitize.colnames.function = function(x) x,sanitize.rownames.function = function(x) x)
  else
    print(xtable(ctab,digits=c(1,3,3,3,4,3,3),display=c("fg","fg","fg","fg","f","fg","fg"),align="l||c|c|c|c|cc|"),floating=FALSE,sanitize.colnames.function = function(x) x,sanitize.rownames.function = function(x) x)
  cc
}
getSummary.mer <- function(mer) {
  msd <- sqrt(diag(vcov(mer)))
  coefs <- fixef(mer)
  mz<-mcmcsamp(mer,bootSize)
  mf <- mz@fixef
  mzp <- 2*pnorm(-abs(mzt <- (mzcoef <- apply(mf,1,mean))/(mzsd <- apply(mf,1,sd))))
  mzci <- cbind(coefs) %*% c(1,1) + cbind(mzsd) %*% rbind(qnorm(c(.025,.975)))
  coef <- cbind(coefs,mzsd,mzt,mzp,mzci)
  colnames(coef) <- c("est", "se", "stat", "p", "lwr", "upr")
  smer<-summary(mer)
  AIC <- smer@AICtab$AIC
  BIC <- smer@AICtab$BIC
  logLik <- smer@AICtab$logLik
  deviance <- smer@AICtab$deviance
  REMSdev <- smer@AICtab$REMSdev
  N <- length(mer@resid)
  ngrps<-min(smer@ngrps)
  mgrps<-max(smer@ngrps)
  sumstat <- c(deviance=deviance,AIC=AIC,BIC=BIC,logLik=logLik,N=N,ngrps=ngrps,mgrps=mgrps)
  list(coef=coef,sumstat=sumstat,call = mer@call)
}
